/*
 * Decompiled with CFR 0.152.
 */
package ru.betterend.world.structures.piece;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Random;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3341;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_4076;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_6625;
import net.minecraft.class_6880;
import ru.bclib.api.biomes.BiomeAPI;
import ru.bclib.api.tag.CommonBlockTags;
import ru.bclib.util.BlocksHelper;
import ru.bclib.util.MHelper;
import ru.betterend.noise.OpenSimplexNoise;
import ru.betterend.registry.EndBlocks;
import ru.betterend.registry.EndStructures;
import ru.betterend.world.biome.EndBiome;
import ru.betterend.world.structures.piece.BasePiece;

public class LakePiece
extends BasePiece {
    private static final class_2680 ENDSTONE = class_2246.field_10471.method_9564();
    private static final class_2680 WATER = class_2246.field_10382.method_9564();
    private Map<Integer, Byte> heightmap = Maps.newHashMap();
    private OpenSimplexNoise noise;
    private class_2338 center;
    private float radius;
    private float aspect;
    private float depth;
    private int seed;
    private class_2960 biomeID;

    public LakePiece(class_2338 center, float radius, float depth, Random random, class_6880<class_1959> biome) {
        super(EndStructures.LAKE_PIECE, random.nextInt(), null);
        this.center = center;
        this.radius = radius;
        this.depth = depth;
        this.seed = random.nextInt();
        this.noise = new OpenSimplexNoise(this.seed);
        this.aspect = radius / depth;
        this.biomeID = BiomeAPI.getBiomeID((class_1959)((class_1959)biome.comp_349()));
        this.makeBoundingBox();
    }

    public LakePiece(class_6625 type, class_2487 tag) {
        super(EndStructures.LAKE_PIECE, tag);
        this.makeBoundingBox();
    }

    @Override
    protected void addAdditionalSaveData(class_2487 tag) {
        tag.method_10566("center", (class_2520)class_2512.method_10692((class_2338)this.center));
        tag.method_10548("radius", this.radius);
        tag.method_10548("depth", this.depth);
        tag.method_10569("seed", this.seed);
        tag.method_10582("biome", this.biomeID.toString());
    }

    @Override
    protected void fromNbt(class_2487 tag) {
        this.center = class_2512.method_10691((class_2487)tag.method_10562("center"));
        this.radius = tag.method_10583("radius");
        this.depth = tag.method_10583("depth");
        this.seed = tag.method_10550("seed");
        this.noise = new OpenSimplexNoise(this.seed);
        this.aspect = this.radius / this.depth;
        this.biomeID = new class_2960(tag.method_10558("biome"));
    }

    public void method_14931(class_5281 world, class_5138 arg, class_2794 chunkGenerator, Random random, class_3341 blockBox, class_1923 chunkPos, class_2338 blockPos) {
        int minY = this.field_15315.method_35416();
        int maxY = this.field_15315.method_35419();
        int sx = class_4076.method_18688((int)chunkPos.field_9181);
        int sz = class_4076.method_18688((int)chunkPos.field_9180);
        class_2338.class_2339 mut = new class_2338.class_2339();
        class_2791 chunk = world.method_8392(chunkPos.field_9181, chunkPos.field_9180);
        for (int x = 0; x < 16; ++x) {
            mut.method_33097(x);
            int wx = x | sx;
            double nx = (double)wx * 0.1;
            int x2 = wx - this.center.method_10263();
            for (int z = 0; z < 16; ++z) {
                mut.method_33099(z);
                int wz = z | sz;
                double nz = (double)wz * 0.1;
                int z2 = wz - this.center.method_10260();
                float clamp = this.getHeightClamp(world, 8, wx, wz);
                if ((double)clamp < 0.01) continue;
                double n = this.noise.eval(nx, nz) * 1.5 + 1.5;
                double x3 = MHelper.sqr((double)((double)x2 + this.noise.eval(nx, nz, 100.0) * 10.0));
                double z3 = MHelper.sqr((double)((double)z2 + this.noise.eval(nx, nz, -100.0) * 10.0));
                for (int y = maxY; y >= minY; --y) {
                    class_2338 worldPos;
                    class_2680 state;
                    mut.method_33098((int)((double)y + n));
                    double y2 = MHelper.sqr((float)((float)(y - this.center.method_10264()) * this.aspect));
                    double r2 = this.radius * clamp;
                    double r3 = r2 + 8.0;
                    r2 *= r2;
                    r3 = r3 * r3 + 100.0;
                    double dist = x3 + y2 + z3;
                    if (dist < r2) {
                        state = chunk.method_8320((class_2338)mut);
                        if (!state.method_26164(CommonBlockTags.GEN_END_STONES) && !state.method_26215()) continue;
                        state = mut.method_10264() < this.center.method_10264() ? WATER : field_15314;
                        chunk.method_12010((class_2338)mut, state, false);
                        continue;
                    }
                    if (!(dist <= r3) || mut.method_10264() >= this.center.method_10264() || (state = chunk.method_8320((class_2338)mut)).method_26234((class_1922)world, worldPos = mut.method_10069(sx, 0, sz)) || state.method_26212((class_1922)world, worldPos)) continue;
                    state = chunk.method_8320(mut.method_10084());
                    state = state.method_26215() ? (random.nextBoolean() ? ENDSTONE : EndBiome.findTopMaterial(world, worldPos)) : (state.method_26227().method_15769() ? ENDSTONE : EndBlocks.ENDSTONE_DUST.method_9564());
                    chunk.method_12010((class_2338)mut, state, false);
                }
            }
        }
        this.fixWater(world, chunk, mut, random, sx, sz);
    }

    private void fixWater(class_5281 world, class_2791 chunk, class_2338.class_2339 mut, Random random, int sx, int sz) {
        int minY = this.field_15315.method_35416();
        int maxY = this.field_15315.method_35419();
        for (int x = 0; x < 16; ++x) {
            mut.method_33097(x);
            for (int z = 0; z < 16; ++z) {
                mut.method_33099(z);
                block2: for (int y = minY; y <= maxY; ++y) {
                    mut.method_33098(y);
                    class_3610 state = chunk.method_8316((class_2338)mut);
                    if (!state.method_15769()) {
                        mut.method_33098(y - 1);
                        if (chunk.method_8320((class_2338)mut).method_26215()) {
                            mut.method_33098(y + 1);
                            class_2680 bState = chunk.method_8320((class_2338)mut);
                            bState = bState.method_26215() ? (random.nextBoolean() ? ENDSTONE : EndBiome.findTopMaterial(world, mut.method_10069(sx, 0, sz))) : (bState.method_26227().method_15769() ? ENDSTONE : EndBlocks.ENDSTONE_DUST.method_9564());
                            mut.method_33098(y);
                            this.makeEndstonePillar(chunk, mut, bState);
                            continue;
                        }
                        if (x > 1 && x < 15 && z > 1 && z < 15) {
                            mut.method_33098(y);
                            for (class_2350 dir : BlocksHelper.HORIZONTAL) {
                                class_2338 wPos = mut.method_10069(dir.method_10148(), 0, dir.method_10165());
                                if (!chunk.method_8320(wPos).method_26215()) continue;
                                mut.method_33098(y + 1);
                                class_2680 bState = chunk.method_8320((class_2338)mut);
                                bState = bState.method_26215() ? (random.nextBoolean() ? ENDSTONE : EndBiome.findTopMaterial(world, mut.method_10069(sx, 0, sz))) : (bState.method_26227().method_15769() ? ENDSTONE : EndBlocks.ENDSTONE_DUST.method_9564());
                                mut.method_33098(y);
                                this.makeEndstonePillar(chunk, mut, bState);
                                continue block2;
                            }
                            continue;
                        }
                        if (!chunk.method_8320((class_2338)mut.method_10098(class_2350.field_11036)).method_26215()) continue;
                        chunk.method_12039(mut.method_10098(class_2350.field_11033).method_10062());
                        continue;
                    }
                    if (!chunk.method_8320((class_2338)mut).method_26229()) continue;
                    chunk.method_12039(mut.method_10062());
                }
            }
        }
    }

    private void makeEndstonePillar(class_2791 chunk, class_2338.class_2339 mut, class_2680 terrain) {
        chunk.method_12010((class_2338)mut, terrain, false);
        mut.method_33098(mut.method_10264() - 1);
        while (!chunk.method_8316((class_2338)mut).method_15769()) {
            chunk.method_12010((class_2338)mut, ENDSTONE, false);
            mut.method_33098(mut.method_10264() - 1);
        }
    }

    private int getHeight(class_5281 world, class_2338 pos) {
        int p = (pos.method_10263() & 0x7FF) << 11 | pos.method_10260() & 0x7FF;
        int h = this.heightmap.getOrDefault(p, (byte)-128).byteValue();
        if (h > -128) {
            return h;
        }
        if (!BiomeAPI.getBiomeID((class_6880)world.method_23753(pos)).equals((Object)this.biomeID)) {
            this.heightmap.put(p, (byte)0);
            return 0;
        }
        h = world.method_8624(class_2902.class_2903.field_13194, pos.method_10263(), pos.method_10260());
        h = (h = class_3532.method_15382((int)(h - this.center.method_10264()))) < 8 ? 1 : 0;
        this.heightmap.put(p, (byte)h);
        return h;
    }

    private float getHeightClamp(class_5281 world, int radius, int posX, int posZ) {
        class_2338.class_2339 mut = new class_2338.class_2339();
        int r2 = radius * radius;
        float height = 0.0f;
        float max = 0.0f;
        for (int x = -radius; x <= radius; ++x) {
            mut.method_33097(posX + x);
            int x2 = x * x;
            for (int z = -radius; z <= radius; ++z) {
                mut.method_33099(posZ + z);
                int z2 = z * z;
                if (x2 + z2 >= r2) continue;
                float mult = 1.0f - (float)Math.sqrt(x2 + z2) / (float)radius;
                max += mult;
                height += (float)this.getHeight(world, (class_2338)mut) * mult;
            }
        }
        return class_3532.method_15363((float)(height /= max), (float)0.0f, (float)1.0f);
    }

    private void makeBoundingBox() {
        int minX = MHelper.floor((double)((float)this.center.method_10263() - this.radius - 8.0f));
        int minY = MHelper.floor((double)((float)this.center.method_10264() - this.depth - 8.0f));
        int minZ = MHelper.floor((double)((float)this.center.method_10260() - this.radius - 8.0f));
        int maxX = MHelper.floor((double)((float)this.center.method_10263() + this.radius + 8.0f));
        int maxY = MHelper.floor((double)((float)this.center.method_10264() + this.depth));
        int maxZ = MHelper.floor((double)((float)this.center.method_10260() + this.radius + 8.0f));
        this.field_15315 = new class_3341(minX, minY, minZ, maxX, maxY, maxZ);
    }
}

